within Buildings.Controls.OBC.CDL.Continuous.Validation;
model Log10 "Validation model for the Log10 block"
extends Modelica.Icons.Example;

  Buildings.Controls.OBC.CDL.Continuous.Log10 log10_1
    "Block that outputs the base 10 logarithm of the input (input > 0 required)"
    annotation (Placement(transformation(extent={{-10,-10},{10,10}})));
  Buildings.Controls.OBC.CDL.Continuous.Sources.Ramp ramp1(
    duration=1,
    offset=1,
    height=9) "Block that generates ramp signal"
    annotation (Placement(transformation(extent={{-60,-10},{-40,10}})));
equation
  connect(ramp1.y, log10_1.u)
    annotation (Line(points={{-39,0},{-12,0}},         color={0,0,127}));
  annotation (
experiment(StopTime=1.0, Tolerance=1e-06),
  __Dymola_Commands(file="modelica://Buildings/Resources/Scripts/Dymola/Controls/OBC/CDL/Continuous/Validation/Log10.mos"
        "Simulate and plot"),
    Documentation(info="<html>
<p>
Validation test for the block
<a href=\"modelica://Buildings.Controls.OBC.CDL.Continuous.Log10\">
Buildings.Controls.OBC.CDL.Continuous.Log10</a>.
</p>
<p>
The input <code>u</code> varies from <i>+1</i> to <i>+10</i>.
</p>
</html>", revisions="<html>
<ul>
<li>
March 22, 2017, by Jianjun Hu:<br/>
First implementation.
</li>
</ul>

</html>"));
end Log10;
